package gov.va.med.term.mvx.propertyTypes;

import gov.va.med.term.mvx.mojo.FieldsV1;
import gov.va.oia.terminology.converters.sharedUtils.propertyTypes.BPT_Annotations;
import gov.va.oia.terminology.converters.sharedUtils.propertyTypes.Property;

public class PT_Annotations extends BPT_Annotations
{
	public enum Attribute
	{
		MVX_CODE(FieldsV1.MVX_CODE, true);

		private final Property property_;

		private Attribute(FieldsV1 fieldName, boolean isIdentifier)
		{
			// Don't know the owner yet - will be autofilled when we add this to the parent, below.
			property_ = new Property(null, fieldName.toString(), isIdentifier);
		}

		public Property getProperty()
		{
			return property_;
		}
	}

	public PT_Annotations()
	{
		super("MVX");
		for (Attribute attr : Attribute.values())
		{
			addProperty(attr.getProperty());
		}
	}
}
